/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.ai;

import com.flemmli97.improvedmobs.mixin.MobEntityMixin;
import com.flemmli97.improvedmobs.utils.GeneralHelperMethods;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class FlyRidingGoal
extends Goal {
    public static final ResourceLocation EMPTY = new ResourceLocation("improvedmobs", "empty");
    protected final MobEntity living;
    private int iddle;
    private int pathCheckWait;
    private int flyDelay;
    private int targetDelay;
    private boolean start;
    private PathNavigator flyer;

    public FlyRidingGoal(MobEntity living) {
        this.living = living;
        this.flyer = new FlyingPathNavigator(living, living.field_70170_p){

            public boolean func_188555_b(BlockPos blockPos) {
                return true;
            }
        };
    }

    public boolean func_75250_a() {
        if (this.living.func_184187_bx() instanceof ParrotEntity) {
            return true;
        }
        LivingEntity target = this.living.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            this.targetDelay = 0;
        } else if (!this.living.func_184218_aH() && ++this.targetDelay > 40 && --this.pathCheckWait <= 0) {
            this.pathCheckWait = 25;
            if (this.checkFlying()) {
                this.targetDelay = 0;
                this.iddle = 0;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.living.func_184187_bx() instanceof ParrotEntity) {
            this.iddle = this.living.func_70638_az() == null ? ++this.iddle : 0;
            return this.iddle < 100;
        }
        return false;
    }

    public void func_75251_c() {
        this.living.func_184210_p();
        this.living.func_195064_c(new EffectInstance(Effects.field_204839_B, 200, 1));
        this.iddle = 0;
        this.targetDelay = 0;
    }

    public void func_75249_e() {
        this.start = true;
    }

    public void func_75246_d() {
        Entity entity;
        if (this.start) {
            if (!this.living.func_184218_aH()) {
                ParrotEntity boat = (ParrotEntity)EntityType.field_200783_W.func_200721_a(this.living.field_70170_p);
                BlockPos pos = this.living.func_233580_cy_();
                boat.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, this.living.field_70177_z, this.living.field_70125_A);
                AttributeModifier mod = this.living.func_110148_a(Attributes.field_233821_d_).func_111127_a(GeneralHelperMethods.attMod);
                if (mod != null) {
                    boat.func_110148_a(Attributes.field_233822_e_).func_233769_c_(new AttributeModifier(GeneralHelperMethods.attMod, "ride.fly.boost", mod.func_111164_d() * 1.2, AttributeModifier.Operation.ADDITION));
                }
                if (this.living.field_70170_p.func_226669_j_((Entity)boat)) {
                    ((MobEntityMixin)boat).setDeathLootTable(EMPTY);
                    boat.getPersistentData().func_74757_a("improvedmobs:water_riding", true);
                    this.living.field_70170_p.func_217376_c((Entity)boat);
                    this.living.func_184220_m((Entity)boat);
                    this.flyDelay = 0;
                }
            }
            this.start = false;
        }
        if (!((entity = this.living.func_184187_bx()) instanceof ParrotEntity) || !entity.func_70089_S()) {
            return;
        }
        if (++this.flyDelay >= 40 && this.isOnLand(entity)) {
            this.living.func_184210_p();
        }
    }

    private boolean checkFlying() {
        LivingEntity target = this.living.func_70638_az();
        if ((double)Math.abs(this.living.field_191988_bg) > 0.005 || (double)Math.abs(this.living.field_70702_br) > 0.005 || this.living.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()) <= this.getAttackReachSqr(target)) {
            return false;
        }
        if (this.living.func_189652_ae() || !this.living.func_233570_aj_()) {
            return false;
        }
        Path path = this.living.func_70661_as().func_75505_d();
        if (path == null || path.func_75879_b() && !path.func_224771_h()) {
            Path ground = this.living.func_70661_as().func_75494_a((Entity)this.living.func_70638_az(), 1);
            if (ground != null && ground.func_224771_h()) {
                return false;
            }
            Path flyer = this.flyer.func_75494_a((Entity)target, 1);
            double dist = path == null ? (double)this.living.func_233580_cy_().func_218139_n((Vector3i)target.func_233580_cy_()) : (double)path.func_224769_l();
            return flyer != null && (flyer.func_224771_h() || (double)flyer.func_224769_l() < dist);
        }
        return false;
    }

    private boolean isOnLand(Entity riding) {
        if (this.living.func_70661_as().func_75500_f() && riding.field_70170_p.func_180495_p(riding.func_233580_cy_().func_177977_b()).func_185904_a().func_76220_a()) {
            return true;
        }
        LivingEntity target = this.living.func_70638_az();
        if (target != null && this.living.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()) <= this.getAttackReachSqr(target)) {
            return riding.field_70170_p.func_180495_p(riding.func_233580_cy_().func_177977_b()).func_185904_a().func_76220_a();
        }
        PathNavigator trueNav = ((MobEntityMixin)this.living).getTrueNavigator();
        if (target != null) {
            if (this.living.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()) <= this.getAttackReachSqr(target)) {
                return riding.field_70170_p.func_180495_p(riding.func_233580_cy_().func_177977_b()).func_185904_a().func_76220_a();
            }
            if (--this.pathCheckWait > 0) {
                return false;
            }
            Path ground = trueNav.func_75494_a((Entity)target, 1);
            this.pathCheckWait = 25;
            if (ground != null && ground.func_224771_h()) {
                return riding.field_70170_p.func_180495_p(riding.func_233580_cy_().func_177977_b()).func_185904_a().func_76220_a();
            }
        }
        return false;
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.living.func_213311_cf() * 2.0f * this.living.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
    }
}

